<?php // Do NOT copy this opening PHP tag

/**
 * @author  Brad Dalton
 * @link    https://wpsites.net/?p=110574
*/ 


function genesis_human_time_diff( $older_date, $newer_date = false, $relative_depth = 2 ) {

	if ( ! is_int( $older_date ) ) {
		return '';
	}

	// If no newer date is given, assume now.
	$newer_date = $newer_date ?: time();

	// Difference in seconds.
	$since = absint( $newer_date - $older_date );

	if ( ! $since ) {
		return '0 ' . _x( 'seconds', 'time difference', 'genesis' );
	}

	// Hold units of time in seconds, and their pluralised strings (not translated yet).
	$units = [
		/* translators: %s: Number of year(s). */
		[ 31536000, _nx_noop( '%s year', '%s years', 'time difference', 'genesis' ) ],  // 60 * 60 * 24 * 365
		/* translators: %s: Number of month(s). */
		[ 2592000, _nx_noop( '%s month', '%s months', 'time difference', 'genesis' ) ], // 60 * 60 * 24 * 30
		/* translators: %s: Number of week(s). */
		[ 604800, _nx_noop( '%s week', '%s weeks', 'time difference', 'genesis' ) ],    // 60 * 60 * 24 * 7
		/* translators: %s: Number of day(s). */
		[ 86400, _nx_noop( '%s day', '%s days', 'time difference', 'genesis' ) ],       // 60 * 60 * 24
		/* translators: %s: Number of hour(s). */
		[ 3600, _nx_noop( '%s hour', '%s hours', 'time difference', 'genesis' ) ],      // 60 * 60
		/* translators: %s: Number of minute(s). */
		[ 60, _nx_noop( '%s minute', '%s minutes', 'time difference', 'genesis' ) ],
		/* translators: %s: Number of second(s). */
		[ 1, _nx_noop( '%s second', '%s seconds', 'time difference', 'genesis' ) ],
	];

	// Build output with as many units as specified in $relative_depth.
	$relative_depth = (int) $relative_depth ?: 2;

	$i = 0;

	$counted_seconds = 0;

	$date_partials        = [];
	$amount_date_partials = 0;
	$amount_units         = count( $units );

	while ( $amount_date_partials < $relative_depth && $i < $amount_units ) {
		$seconds = $units[ $i ][0];
		$count   = (int) floor( ( $since - $counted_seconds ) / $seconds );
		if ( 0 !== $count ) {
			$date_partials[]      = sprintf( translate_nooped_plural( $units[ $i ][1], $count, 'genesis' ), $count );
			$counted_seconds     += $count * $seconds;
			$amount_date_partials = count( $date_partials );
		}
		$i++;
	}

	if ( empty( $date_partials ) ) {
		$output = '';
	} elseif ( 1 === count( $date_partials ) ) {
		$output = $date_partials[0];
	} else {

		// Combine all but last partial using commas.
		$output = implode( ', ', array_slice( $date_partials, 0, -1 ) );

		// Add 'and' separator.
		$output .= ' ' . _x( 'and', 'separator in time difference', 'genesis' ) . ' ';

		// Add last partial.
		$output .= end( $date_partials );
	}

	return $output;

}


function genesis_product_date() {

	$atts = [
		'after'          => '',
		'before'         => '',
		'format'         => get_option( 'date_format' ),
		'label'          => '',
		'relative_depth' => 2,
	];

	if ( 'relative' === $atts['format'] ) {
		$display  = genesis_human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ), $atts['relative_depth'] ); 
	} else {
		$display = get_the_time( $atts['format'] );
	}

	$output = sprintf( '<time class="product-date" itemprop="datePublished" datetime="%s">', get_the_time( 'c' ) ) . $atts['before'] . $atts['label'] . $display . $atts['after'] . '</time>';

	return $output;

}


add_action( 'woocommerce_single_product_summary', 'add_product_date', 25 );
function add_product_date() {

   if ( is_product() &&  ! empty( get_post_meta( get_the_ID(), 'product_date', true ) ) ) {
   
      echo genesis_product_date();
      
   }
}
 
