jQuery(document).ready(function($) {
    // Detect change in the shipping method radio buttons
    $(document).on('change', 'input[name="shipping_method[0]"]', function() {
        var selectedMethod = $(this).val(); // Get selected shipping method value

        $.ajax({
            type: 'POST',
            url: shippingMethodAjax.ajax_url, // Defined in wp_localize_script
            data: {
                action: 'update_shipping_zone',
                selected_method: selectedMethod
            },
            success: function(response) {
                if (response.success) {
                    // Update shipping zone info in the cart
                    $('#shipping-zone-info').html('<p>' + response.data + '</p>');
                } else {
                    $('#shipping-zone-info').html('<p>Error: ' + response.data + '</p>');
                }

                // Trigger WooCommerce update event to refresh totals
                $(document.body).trigger('update_checkout');
            }
        });
    });
});

