/**
 * External dependencies
 */
import { __experimentalRegisterCheckoutFilters } from '@woocommerce/blocks-checkout';
import { registerPaymentMethodExtensionCallbacks } from '@woocommerce/blocks-registry';
import { __, sprintf } from '@wordpress/i18n';

export const registerFilters = (pointsLabelPlural, discountRegex) => {
	__experimentalRegisterCheckoutFilters('checkout-block-date-picker', {
		itemName: (name) => {
			return `${name} + extra data!`;
		},
	});

	registerPaymentMethodExtensionCallbacks('checkout-block-date-picker', {
		cod: (arg) => arg.billingData.city !== 'Denver',
	});
};
