<?php
/**
 * Plugin Name: Conditional Free Shipping Packets & Boxes
 * Plugin URI: https://wpsites.net/?p=129431
 * Description: This plugin customizes WooCommerce shipping costs based on the product categories and total cart quantity.
 * Author: Brad Dalton - WP SITES
 * Author URI: https://wpsites.net/bradley-james-dalton-wordpress-developer/
 * Version: 0.1.0
 */

// Use a different approach - modify shipping costs directly
add_filter('woocommerce_shipping_rate_cost', 'custom_shipping_cost_modifier', 10, 2);
function custom_shipping_cost_modifier($cost, $rate) {
    
    // Get cart contents
    $cart = WC()->cart;
    if (!$cart) {
        return $cost;
    }
    
    $packets_category = 'packets'; // category slug
    $boxes_category   = 'boxes';   // category slug

    $packet_qty = 0;
    $box_qty = 0;
    $total_qty = 0;

    // Calculate quantities for each category and total
    foreach ($cart->get_cart() as $cart_item) {
        $product = $cart_item['data'];
        $qty = $cart_item['quantity'];
        $total_qty += $qty;

        // Get product categories safely
        try {
            $terms = get_the_terms($product->get_id(), 'product_cat');
            if (empty($terms) || is_wp_error($terms)) continue;

            foreach ($terms as $term) {
                if ($term->slug === $packets_category) {
                    $packet_qty += $qty;
                } elseif ($term->slug === $boxes_category) {
                    $box_qty += $qty;
                }
            }
        } catch (Exception $e) {
           
            continue;
        }
    }



    // Rule 3: Free shipping if total cart quantity >= 100 (highest priority)
    if ($total_qty >= 100) {
      
        return 0;
    }

    // Rule 2: If any boxes in cart, apply $8 shipping (second priority)
    if ($box_qty > 0) {
     
        return 8.00;
    }

    // Rule 1: Only packets in cart (lowest priority)
    if ($packet_qty > 0) {
        if ($packet_qty < 5) {
            
            return 4.00;
        } else {
           
            return 0;
        }
    }

    // Default fallback — return original cost
    return $cost;
}
